/* <nagg12.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library g12 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2161 (Feb 1998).
 * Mark 6 revised. IER-3048 (July 2000).
 */
#ifndef NAGG12
#define NAGG12

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC

#ifdef __cplusplus
extern "C"
{
#endif
  /* Message codes and extern of message list */
//#include <nag_g12mesg.h>
#include "nag_g12mesg.h"
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL g12aac(Integer n,  double t[],  Integer ic[],  Integer ifreq[],
                                             Integer *nd,  double tp[], double p[], double psig[],
                                             NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g12aaf_f(Integer n, const double t[], const Integer ic[], const char *freq,
                       const Integer ifreq[], Integer *nd, double tp[], double p[],
                       double psig[], Integer iwk[], Integer *ifail, Integer freq_len);
  extern NAG_DLL_EXPIMP void NAG_CALL g12bac(Integer n, Integer m, Integer ns,
                     const double z[], Integer ldz, const Integer isz[], Integer ip,
                     const double t[], const Integer ic[], const double omega[], const Integer isi[],
                     double *dev, double b[], double se[], double sc[],
                     double cov[], double res[], Integer *nd, double tp[],
                     double sur[], Integer tdsur, Integer ndmax,  double tol, Integer maxit,
                     Integer iprint, const char *outfile, NagError *fail);
  extern void g12baf_c(char *offset, Integer n, Integer m, Integer ns,
                       const double z[], Integer ldz, const Integer isz[], Integer ip,
                       const double t[], const Integer ic[], const double omega[], const Integer isi[],
                       double *dev, double b[], double se[], double sc[],
                       double cov[], double res[], Integer *nd, double tp[],
                       double sur[], Integer ndmax, double tol, Integer maxit,
                       Integer iprint, const char *outfile, double wk[], Integer iwk[], Integer *ifail,
                       Integer offset_len);
  extern void g12baf_f(char *offset, Integer n, Integer m, Integer ns,
                       const double z[], Integer ldz, const Integer isz[], Integer ip,
                       const double t[], const Integer ic[], const double omega[], const Integer isi[],
                       double *dev, double b[], double se[], double sc[],
                       double cov[], double res[], Integer *nd, double tp[],
                       double sur[], Integer ndmax, double tol, Integer maxit,
                       Integer iprint, double wk[], Integer iwk[], Integer *ifail,
                       Integer offset_len);
  extern void g12baz_c(Integer m, Integer n, Integer ns, const double z[],
                       Integer ldz, const double avg[], const double t[], const Integer isz[],
                       Integer ip, const Integer isi[], const Integer ic[], Boolean offl,
                       const double omega[], double *dev, double b[], double se[],
                       double sc[], double cov[], double sur[], Integer ndmax,
                       const Integer iord[], const Integer np[], double a[], double si1[],
                       double ss[], double si2[], double wak[], double res[],
                       Integer nd, Integer maxit, Integer iprint, double tol,
                       Integer *iter, Nag_FileSt *stream, Integer *ierror);
  extern void g12baz_f(Integer m, Integer n, Integer ns, const double z[],
                       Integer ldz, const double avg[], const double t[], const Integer isz[],
                       Integer ip, const Integer isi[], const Integer ic[], Boolean offl,
                       const double omega[], double *dev, double b[], double se[],
                       double sc[], double cov[], double sur[], Integer ndmax,
                       const Integer iord[], const Integer np[], double a[], double si1[],
                       double ss[], double si2[], double wak[], double res[],
                       Integer nd, Integer maxit, Integer iprint, double tol,
                       Integer *iter, Integer *ierror);

extern  NAG_DLL_EXPIMP void NAG_CALL g12zac(Nag_OrderType order, Integer n, Integer m, Integer ns, const double z[], Integer pdz, const Integer isz[], Integer ip, const double t[], const Integer ic[], const Integer isi[], Integer *num, Integer ixs[], Integer *nxs, double x[], Integer mxn, Integer id[], Integer *nd, double tp[], Integer irs[], NagError *fail); 


  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGG12 */
